// PPgDisplay2.cpp : Implementierungsdatei
//

#include "stdafx.h"
#include "emule.h"
#include "PPgDisplay2.h"
#include "emuledlg.h"
#include "Preferences.h"
#include "OtherFunctions.h"
#include "preferencesdlg.h"


// CPPgDisplay2-Dialogfeld

IMPLEMENT_DYNAMIC(CPPgDisplay2, CPropertyPage)
CPPgDisplay2::CPPgDisplay2()
	: CPropertyPage(CPPgDisplay2::IDD)
{
	m_imageList.DeleteImageList();
	m_imageList.Create(16, 16, theApp.m_iDfltImageListColorFlags | ILC_MASK, 14+1, 0);
	m_imageList.Add(CTempIconLoader(_T("DISPLAY")));
	m_imageList.Add(CTempIconLoader(_T("DISPLAY2")));
}

CPPgDisplay2::~CPPgDisplay2()
{
}

void CPPgDisplay2::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_TAB_DIS2, m_tabCtr);
}


BEGIN_MESSAGE_MAP(CPPgDisplay2, CPropertyPage)
	ON_NOTIFY(TCN_SELCHANGE, IDC_TAB_DIS2, OnTcnSelchangeTabDisplay2)
//==> XPMenu [shadow2004]
	ON_BN_CLICKED(IDC_DIS2_STYLE1, OnSettingsChange)
	ON_BN_CLICKED(IDC_DIS2_STYLE2, OnSettingsChange)
	ON_BN_CLICKED(IDC_DIS2_STYLE3, OnSettingsChange)
	ON_BN_CLICKED(IDC_DIS2_SIDEBAR, OnSettingsChange)
	ON_BN_CLICKED(IDC_DIS2_BITBACK, OnSettingsChange)
//<== XPMenu [shadow2004]

END_MESSAGE_MAP()


// CPPgDisplay2-Meldungshandler

BOOL CPPgDisplay2::OnInitDialog()
{
	CPropertyPage::OnInitDialog();

	InitTab(true,1);
	m_tabCtr.SetCurSel(theApp.emuledlg->preferenceswnd->StartPageDisplay);
	InitWindowStyles(this);

	LoadSettings();
	Localize();

	return TRUE; 
}

void CPPgDisplay2::Localize(void)
{
	if(m_hWnd)
	{
//==> XPMenu [shadow2004]
		GetDlgItem(IDC_DIS2_XPBOX)->SetWindowText(GetResString(IDS_DIS2_XPBOX));
		GetDlgItem(IDC_DIS2_STYLEBOX)->SetWindowText(GetResString(IDS_DIS2_STYLEBOX));
		GetDlgItem(IDC_DIS2_STYLE1)->SetWindowText(GetResString(IDS_DIS2_STYLE1));
		GetDlgItem(IDC_DIS2_STYLE2)->SetWindowText(GetResString(IDS_DIS2_STYLE2));
		GetDlgItem(IDC_DIS2_STYLE3)->SetWindowText(GetResString(IDS_DIS2_STYLE3));
		GetDlgItem(IDC_DIS2_SIDEBAR)->SetWindowText(GetResString(IDS_DIS2_SIDEBAR));
		GetDlgItem(IDC_DIS2_BITBACK)->SetWindowText(GetResString(IDS_DIS2_BITBACK));
//<== XPMenu [shadow2004]
	}
}

void CPPgDisplay2::LoadSettings(void)
{
//==> XPMenu [shadow2004]
		int toStyle = thePrefs.GetXPMenuStyle();
		CheckRadioButton(IDC_DIS2_STYLE1, IDC_DIS2_STYLE3, IDC_DIS2_STYLE1 + toStyle);

		CheckDlgButton(IDC_DIS2_SIDEBAR, (UINT)thePrefs.GetXPSideBar());
		CheckDlgButton(IDC_DIS2_BITBACK, (UINT)thePrefs.GetXPBitmap());
//<== XPMenu [shadow2004]
}

BOOL CPPgDisplay2::OnApply()
{
//==> XPMenu [shadow2004]
		if(IsDlgButtonChecked(IDC_DIS2_STYLE1))
				thePrefs.SetXPMenuStyle(0);
		else if(IsDlgButtonChecked(IDC_DIS2_STYLE2))
				thePrefs.SetXPMenuStyle(1);
		else
				thePrefs.SetXPMenuStyle(2);
		thePrefs.m_bShowXPSideBar = IsDlgButtonChecked(IDC_DIS2_SIDEBAR)!=0;
		thePrefs.m_bShowXPBitmap = IsDlgButtonChecked(IDC_DIS2_BITBACK)!=0;
//<== XPMenu [shadow2004]

	LoadSettings();
	SetModified(FALSE);
	return CPropertyPage::OnApply();
}

void CPPgDisplay2::InitTab(bool firstinit, int Page)
{
	if (firstinit) {
		m_tabCtr.DeleteAllItems();
		m_tabCtr.SetImageList(&m_imageList);
		m_tabCtr.InsertItem(TCIF_TEXT | TCIF_IMAGE | TCIF_PARAM, Display1, GetResString(IDS_DIS1_NAME), 0, (LPARAM)Display1); 
		m_tabCtr.InsertItem(TCIF_TEXT | TCIF_IMAGE | TCIF_PARAM, Display2, GetResString(IDS_DIS2_NAME), 1, (LPARAM)Display2); 
	}

	m_tabCtr.SetCurSel(Page);
}
void CPPgDisplay2::OnTcnSelchangeTabDisplay2(NMHDR* /*pNMHDR*/, LRESULT *pResult)
{
	int cur_sel = m_tabCtr.GetCurSel();
	theApp.emuledlg->preferenceswnd->SwitchTab(cur_sel);
	*pResult = 0;
}